<?php
  BEvent::Hook('comment added', array('CommonNotifications', 'CommentAdded'));

/* one-shot */
  $this->name = 'common notifications';
  $this->Caption('Основные оповещания', 'ru');
/* install CommonNotifications */
class CommonNotifications {
  // if you're the only person writing on this blog you don't need to be notified
  // about your own comments.
  static $skipCommentsByPostAuthor = true;

  static function CommentAdded($parent, $comment, $info) {
    if (!$info['isByPostAuthor'] or !self::$skipCommentsByPostAuthor) {
      $vars = EMailVars::OnNewComment($parent, $comment, $info, $event);

      $subject = self::GetSubject($event, $vars);
      NotifyOf($event, $subject, $vars);
    }
  }

  static function GetSubject($event, array &$vars) {
    return Template::LiteFormat(Translate("email - $event: subject"), $vars);
  }
}
